/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Gfx      gfx;
Download download;
/******************************************************************************/
void InitPre()
{
   App.name="Downloading file";
   App.flag=APP_NO_FX;
   PakAdd("../data/engine.pak");
}
/******************************************************************************/
Bool Init()
{
   Text_ds.color =BLACK;
   Text_ds.shadow=0;

   download.create("http://www.esenthel.com/download/logo.gfx"); // create downloader

   return true;
}
/******************************************************************************/
void Shut()
{
   download.del(); // delete downloader
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;

   if(download.state()==DWNL_DONE) // if all data downloaded successfully
   {
      // data can be accessed freely through Download::buf,size methods
      // for example download.buf()[0] is the first Byte of data
      // we'll use the downloaded data to load an image from it

      if(!gfx.is()) // check if we haven't already created it
      {
         WFile f("data/logo.gfx");               // create a file for writing
         f.put(download.data(),download.size()); // write downloaded data
         f.del();                                // close the file before accessing it, to make sure everything is written
         gfx.Import("data/logo.gfx");            // load image from file
      }
   }
   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear(WHITE);

   if(gfx.is())     // when image is downloaded and created
      gfx.drawFs(); // draw it

   switch(download.state())
   {
      case DWNL_NONE    :D.text(0,   0,  "Nothing");break;
      case DWNL_WAIT    :D.text(0,   0,  "Awaiting for connection..");break;
      case DWNL_DOWNLOAD:D.text(0,   0,S+"Downloading.. "+download.done()+'/'+download.size());break;
      case DWNL_DONE    :D.text(0,-0.9,  "Done");break;
      case DWNL_ERROR   :D.text(0,   0,  "Error encountered");break;
   }
}
/******************************************************************************/
